/*
 * Decompiled with CFR 0.152.
 */
package standard;

import common.control.ConfigurationManager;
import common.misc.GlobalParameters;
import common.ui.Button;
import common.ui.ButtonPanel;
import common.ui.DisplaySizes;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import standard.StandardCanvas;

public final class AdditionalFunctionsButtonPanel
extends ButtonPanel {
    private static final int DOUGLAS_8_WIDTH = 238;
    private static final int DOUGLAS_8_HEIGHT = 50;
    private static final int DOUGLAS_8_X_POS = 4;
    private static final int DOUGLAS_8_Y_POS_VISIBLE = 187;
    private static final int DOUGLAS_8_Y_POS_NOT_VISIBLE = 250;
    private static final int DOUGLAS_8_SPACING = 0;
    private static final int S60_3_2_LS_Y_POS_VISIBLE = 147;
    private static final int S60_3_2_LS_Y_POS_NOT_VISIBLE = 210;
    private int yPosVisible = 0;
    private int yPosNotVisible = 0;
    private int verticalMoveDelta = ConfigurationManager.getInstance().getVerticalMoveDelta();
    private int verticalMovePeriod = ConfigurationManager.getInstance().getVerticalMovePeriod();

    public AdditionalFunctionsButtonPanel(DisplaySizes displaySize) {
        super(displaySize);
        if (displaySize == DisplaySizes.DOUGLAS_8 || displaySize == DisplaySizes.S60_3_1 || displaySize == DisplaySizes.S60_3_1_OLD) {
            this.width = 238;
            this.height = 50;
            this.xPos = 4;
            this.yPosVisible = 187;
            this.yPosNotVisible = 250;
            this.spacing = 0;
        } else if (displaySize == DisplaySizes.S60_3_2_SDK) {
            this.width = 238;
            this.height = 50;
            this.xPos = 4;
            this.yPosVisible = 187;
            this.yPosNotVisible = 250;
            this.spacing = 0;
        } else if (displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK) {
            this.width = 238;
            this.height = 50;
            this.xPos = 4;
            this.yPosVisible = 147;
            this.yPosNotVisible = 210;
            this.spacing = 0;
        } else if (displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            this.width = 238;
            this.height = 50;
            this.xPos = 4;
            this.yPosVisible = 147;
            this.yPosNotVisible = 210;
            this.spacing = 0;
        }
        this.yPos = this.yPosNotVisible;
        this.addButton(8);
        this.addButton(5);
        this.addButton(6);
        this.addButton(7);
        this.addButton(21);
        this.addButton(25);
        this.addButton(26);
        this.addButton(24);
    }

    public void paint(Graphics g) {
        super.paint(g);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = (Button)this.buttons.elementAt(i);
            button.paint(g);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        super.commandAction(command, displayable);
        if (command == GlobalParameters.COMMAND_SELECT && this.calculatorCanvas instanceof StandardCanvas) {
            ((StandardCanvas)this.calculatorCanvas).changeState(3);
        }
    }

    public synchronized void animate(final boolean moveIn) {
        Thread thread = new Thread(){

            public synchronized void run() {
                while (AdditionalFunctionsButtonPanel.this.checkMoveCondition(moveIn)) {
                    if (moveIn) {
                        AdditionalFunctionsButtonPanel.this.move(true);
                    } else {
                        AdditionalFunctionsButtonPanel.this.move(false);
                    }
                    AdditionalFunctionsButtonPanel.this.repaint();
                    try {
                        this.wait(AdditionalFunctionsButtonPanel.this.verticalMovePeriod);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (AdditionalFunctionsButtonPanel.this.calculatorCanvas instanceof StandardCanvas) {
                    StandardCanvas standardCanvas = (StandardCanvas)AdditionalFunctionsButtonPanel.this.calculatorCanvas;
                    if (moveIn) {
                        standardCanvas.changeState(2);
                    } else {
                        standardCanvas.changeState(0);
                    }
                }
            }
        };
        thread.start();
    }

    private void move(boolean moveIn) {
        this.yPos = moveIn ? (this.yPos -= this.verticalMoveDelta) : (this.yPos += this.verticalMoveDelta);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = (Button)this.buttons.elementAt(i);
            if (moveIn) {
                button.setYPos(button.getYPos() - this.verticalMoveDelta);
                continue;
            }
            button.setYPos(button.getYPos() + this.verticalMoveDelta);
        }
    }

    private boolean checkMoveCondition(boolean moveIn) {
        if (moveIn) {
            return this.yPos > this.yPosVisible;
        }
        return this.yPos < this.yPosNotVisible;
    }
}

